uniform sampler2D waveW;
uniform sampler2D waveC;
uniform float loopStart;
uniform float loopEnd;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = vec4(0.0,0.0,0.0,0.0);
	float h0 = texture2D(waveW, vec2(uv.x,0.5)).r;
	float h1 = texture2D(waveW, vec2(uv.x,0.5)).g;
	if (uv.y < h0 && uv.y > h1)
	{
		color = texture2D(waveC, vec2(uv.x,0.5));
	}
	if (uv.x>=loopStart && uv.x<=loopEnd)
	{
		float mult =  max((uv.y-0.5)*2.0, ((1.0-uv.y)-0.5)*2.0);
		vec3 c = vec3(0.6, 0.6, 0.6);
		color.rgb = max(color.rgb, mult*c);
		color.a = 1.0;
	}
	gl_FragColor = color;
}
